/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DataType;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedDataTransferFtpReply;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RETR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RETR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            InetAddress address;
            long skipLen = session.getFileOffset();
            String fileName = request.getArgument();
            if (fileName == null) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 501, "RETR", null, null));
                return;
            }
            FtpFile file = null;
            try {
                file = session.getFileSystemView().getFile(fileName);
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting file object", (Throwable)ex);
            }
            if (file == null) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.missing", fileName, file));
                return;
            }
            fileName = file.getAbsolutePath();
            if (!file.doesExist()) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.missing", fileName, file));
                return;
            }
            if (!file.isFile()) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.invalid", fileName, file));
                return;
            }
            if (!file.isReadable()) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "RETR.permission", fileName, file));
                return;
            }
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 150, "RETR", null));
            boolean failure = false;
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception getting the output data stream", (Throwable)e);
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 425, "RETR", null, file));
                session.resetState();
                session.getDataConnection().closeDataConnection();
                return;
            }
            long transSz = 0L;
            try (InputStream is = this.openInputStream(session, file, skipLen);){
                transSz = dataConnection.transferToClient(session.getFtpletSession(), is);
                if (is != null) {
                    is.close();
                }
                this.LOG.info("File downloaded {}", (Object)fileName);
                ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                if (ftpStat != null) {
                    ftpStat.setDownload(session, file, transSz);
                }
            }
            catch (SocketException ex) {
                this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 426, "RETR", fileName, file, transSz));
            }
            catch (IOException ex) {
                this.LOG.debug("IOException during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 551, "RETR", fileName, file, transSz));
            }
            if (!failure) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 226, "RETR", fileName, file, transSz));
            }
        }
        finally {
            session.resetState();
            session.getDataConnection().closeDataConnection();
        }
    }

    public InputStream openInputStream(FtpIoSession session, FtpFile file, long skipLen) throws IOException {
        InputStream in;
        if (session.getDataType() == DataType.ASCII) {
            long offset = 0L;
            in = new BufferedInputStream(file.createInputStream(0L));
            while (offset++ < skipLen) {
                int c = in.read();
                if (c == -1) {
                    throw new IOException("Cannot skip");
                }
                if (c != 10) continue;
                ++offset;
            }
        } else {
            in = file.createInputStream(skipLen);
        }
        return in;
    }
}

